/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.build;

import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.index.core.build.BuildContext;
import com.aptana.js.internal.core.index.JSMetadataReader;
import com.aptana.sax.IValidatingReaderLogger;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class SDocMLValidator
extends AbstractBuildParticipant {
    public static final String ID = "com.aptana.js.core.SDocMLValidator";

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.js.core.sdocml_problem");
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        final ArrayList<IProblem> problems = new ArrayList<IProblem>();
        final String path = context.getURI().toString();
        JSMetadataReader reader = new JSMetadataReader();
        IValidatingReaderLogger collector = new IValidatingReaderLogger(){

            public void logError(String message, int line, int column) {
                problems.add(SDocMLValidator.this.createError(message, line, column, 0, path));
            }

            public void logInfo(String message, int line, int column) {
                problems.add(SDocMLValidator.this.createInfo(message, line, column, 0, path));
            }

            public void logWarning(String message, int line, int column) {
                problems.add(SDocMLValidator.this.createWarning(message, line, column, 0, path));
            }
        };
        reader.setLogger(collector);
        try {
            InputStream input = context.openInputStream(monitor);
            reader.loadXML(input, context.getURI().toString());
        }
        catch (Exception e) {
            problems.add(this.createError(e.getMessage(), 0, 0, 0, path.toString()));
        }
        context.putProblems("com.aptana.js.core.sdocml_problem", problems);
    }
}

